package bsf_wakati;
use strict;
use warnings;
use utf8;
use Encode qw/decode_utf8/;

our $VERSION='0.2.0';

sub wakati{
	my $str = shift;

	$str = decode_utf8($str);

	$str =~ s/(\[|\]|_)/ /g;
	$str =~ s/\// /g;
	$str =~ s/\x0a/ /g;
	$str =~ s/\x0d/ /g;
	$str =~ s/\t/ /g;
	$str =~ s/。+/ /g;
	$str =~ s/。+/ /g;
	$str =~ s/、+/ /g;
	$str =~ s/　+/ /g;
	$str =~ s/ +/ /g;

	$str =~ s/([●■◆▲○□◇△・]+)/$1 /g;
	$str =~ s/([！？【】『』「」《》（）()\[\]\<\>\{\}]+)/$1 /g;

	$str =~ s/([ア-ンーァィゥェォヮッャュョ]+)/$1 /g;
#	$str =~ s/([あ-んーぁぇぃぉっぅヵヶゎゃゅょ]+)/$1 /g;
	$str =~ s/([あ-んぁぇぃぉっぅヵヶゎゃゅょ]+)/$1 /g;
	$str =~ s/([０-９ａ-ｚＡ-Ｚ]+)/$1 /g;
	$str =~ s/([一-龠]+)/$1 /g;
	$str =~ s/([0-9a-zA-Z'\.\-\:\/\!\@\?]+)/$1 /g;
	$str =~ s/([ｱ-ﾝｰ]+)/$1 /ig;

	$str =~ s/ +/ /g;
	$str =~ s/^ +//g;
	$str =~ s/ +$//g;

	$str;
}

1;
