#!/usr/bin/perl
use strict;
use warnings;
use utf8;
use DBI;

my $DB = 'VOTE.DB';

&add_column();

binmode STDOUT,':utf8';
print "Content-type: text/html\n\n";
print "データベースのアップグレードが完了しました。db_upgrade.cgiはサーバー上から削除してください。";
exit(0);


#----------------------------------------------------------
#	error
#----------------------------------------------------------
sub error{
	my $ERRSTR = shift || 'error';

	binmode STDOUT,':utf8';
	print "Content-type: text/html\n\n";
	print "ERROR: $ERRSTR\n";
	exit(0);
}


sub add_column{
	my $id = shift || 0;

	my $hDB = DBI->connect("dbi:SQLite:dbname=$DB","","",{PrintError=>0,AutoCommit=>0});
	unless($hDB){&error($DBI::errstr);}

	my $hst = $hDB->do('ALTER TABLE TBL_VOTE ADD COLUMN ip text');
	if(!$hst){&dberror('1:',$hDB,$hst);}

	undef $hst if($hst);
	$hDB->commit;
	$hDB->disconnect;
}

sub dberror{
	my $msg = shift||'';
	my $hDB = shift;
	my $hst = shift;

	my $errstr = $hDB->errstr;
	$hst->finish if($hst);
	$hDB->rollback;
	undef $hst if($hst);
	$hDB->disconnect;
	&error("$msg$errstr");
}
