#!/usr/bin/perl
#
#	2011.02.03
#	・IPチェックによる連続投票の抑制機能追加
#
use strict;
use warnings;
use utf8;
use CGI;
use DBI;
use Encode qw/decode_utf8/;

#画像のパス環境に合わせて設定。http://から星の画像がある場所までを指定
my $IMG     = 'http://example.com/vote/img';
# 0:IPチェックしない 1:同一IPからの連続アクセスを抑制
my $IPCHK   = 1; 

my $DB      = 'VOTE.DB';
my $VERSION = '0.20';

my $q = new CGI;
my $id = $q->escapeHTML(decode_utf8($q->param('id')));
my $p = $q->escapeHTML(decode_utf8($q->param('p')));

&kescape($id);
&kescape($p);

unless($id){&error('no id');}
&error('invalid id') if($id =~ /[^0-9]/);

my ($totalp,$votes) = 0;
if($p eq '' || $p =~ /[^0-9]/){
	($totalp,$votes) = &getAverage($id);
}else{
	($totalp,$votes) = &setDB($id,$p);
}

my $str = '';
if($totalp == 0){
	$str = '未評価';
}else{
	my $average = sprintf("%1.2f",$totalp/$votes);
	my $s = &star($average);
	$str = "<img src=\"$IMG/s$s.gif\" alt=\"rate:$average\" title=\"rate:$average\"><br>($votes votes)";
}


binmode STDOUT,':utf8';
print "Content-type: text/html\n\n$str";
exit(0);

#----------------------------------------------------------
#	kescape
#----------------------------------------------------------
sub kescape{
	$_[0] ||='';
	$_[0] =~ s/\x0d//g;
	$_[0] =~ s/\x0a//g;
	$_[0] =~ s/\x0//g;
}

#----------------------------------------------------------
#	error
#----------------------------------------------------------
sub error{
	my $ERRSTR = shift || 'error';

	binmode STDOUT,':utf8';
	print "Content-type: text/html\n\n";
	print "ERROR: $ERRSTR\n";
	exit(0);
}

#----------------------------------------------------------
#	star
#----------------------------------------------------------
sub star{
	my $p = shift || 1;

	if   ($p > 4.7){ return '50'; }
	elsif($p > 4.2){ return '45'; }
	elsif($p > 3.7){ return '40'; }
	elsif($p > 3.2){ return '35'; }
	elsif($p > 2.7){ return '30'; }
	elsif($p > 2.2){ return '25'; }
	elsif($p > 1.7){ return '20'; }
	elsif($p > 1.2){ return '15'; }
	elsif($p > 0)  { return '10'; }
}

#	テーブル名：TBL_VOTE
#1	entry_id   INTEGER UNIQUE	記事ID
#2	vote_num   INTEGER			投票回数
#3	totalpoint INTEGER			総合点数
sub getAverage{
	my $id = shift || 0;

	my $hDB = DBI->connect("dbi:SQLite:dbname=$DB","","",{PrintError=>0,AutoCommit=>0});
	unless($hDB){&error($DBI::errstr);}

	my $hst = $hDB->prepare('select vote_num,totalpoint from TBL_VOTE WHERE entry_id=?');
	unless($hst){	&dberror('1:',$hDB,$hst);	}

	my $retval = $hst->execute($id);
	unless($retval){&dberror('2:',$hDB,$hst);}

	my ($vote_num,$totalpoint) = ();
	while(my $ref = $hst->fetchrow_arrayref()){
		($vote_num,$totalpoint) = @$ref;
	}
	$hst->finish;
	undef $hst if($hst);
	$hDB->disconnect;

	$vote_num = $vote_num || 0;
	$totalpoint = $totalpoint || 0;

	return (0,0) if($vote_num == 0);

	($totalpoint,$vote_num);
}

#	テーブル名：TBL_VOTE
#1	entry_id   INTEGER UNIQUE	記事ID
#2	vote_num   INTEGER			投票回数
#3	totalpoint INTEGER			総合点数
sub setDB{
	my $id = shift || 0;
	my $p  = shift || 0;

	my $hDB = DBI->connect("dbi:SQLite:dbname=$DB","","",{PrintError=>0,AutoCommit=>0});
	unless($hDB){&error($DBI::errstr);}

	my $hst = $hDB->prepare('select vote_num,totalpoint,ip from TBL_VOTE WHERE entry_id=?');
	unless($hst){	&dberror('1:',$hDB,$hst);	}

	my $retval = $hst->execute($id);
	unless($retval){&dberror('2:',$hDB,$hst);}

	my ($vote_num,$totalpoint,$ip) = ();
	while(my $ref = $hst->fetchrow_arrayref()){
		($vote_num,$totalpoint,$ip) = @$ref;
	}
	$vote_num = $vote_num || 0;
	$totalpoint = $totalpoint || 0;
	$ip = $ip || '';

	#同一IPからの連続投票は受け付けない
	if($IPCHK == 1 && $ENV{'REMOTE_ADDR'} eq $ip){
	}
	#INSERT
	elsif($vote_num == 0){
		$vote_num++;
		$totalpoint += $p;
		$hst = $hDB->prepare('INSERT INTO TBL_VOTE VALUES(?,?,?,?)');
		unless($hst)	{&dberror('3:',$hDB,$hst);}
		my $retval = $hst->execute($id,$vote_num,$totalpoint,$ENV{'REMOTE_ADDR'});
		unless($retval)	{&dberror('4:',$hDB,$hst);}
	}
	#UPDATE
	else{
		$vote_num++;
		$totalpoint += $p;
		$hst = $hDB->prepare('UPDATE TBL_VOTE SET vote_num=?,totalpoint=?,ip=? WHERE entry_id=?');
		unless($hst)	{&dberror('5:',$hDB,$hst);}
		#データ更新
		my $retval = $hst->execute($vote_num,$totalpoint,$ENV{'REMOTE_ADDR'},$id);
		unless($retval)	{&dberror('6:',$hDB,$hst);}
	}

	$hst->finish;
	undef $hst if($hst);
	$hDB->commit;
	$hDB->disconnect;

	($totalpoint,$vote_num);
}

sub dberror{
	my $msg = shift||'';
	my $hDB = shift;
	my $hst = shift;

	my $errstr = $hDB->errstr;
	$hst->finish if($hst);
	$hDB->rollback;
	undef $hst if($hst);
	$hDB->disconnect;
	&error("$msg$errstr");
}
